unit Diakm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Menu: TMenuItem;
    Adatokmegadasa: TMenuItem;
    Betoltes: TMenuItem;
    Kiertekeles: TMenuItem;
    N1: TMenuItem;
    Kilepes: TMenuItem;
    OpenDialog1: TOpenDialog;
    Megjelenites: TMenuItem;
    procedure AdatokmegadasaClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure KilepesClick(Sender: TObject);
    procedure BetoltesClick(Sender: TObject);
    procedure MegjelenitesClick(Sender: TObject);
    procedure KiertekelesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses DiakFeltolt,DiakAdat, DiakLista, MinMax;

{$R *.DFM}

procedure TForm1.AdatokmegadasaClick(Sender: TObject);
begin
   Form3.ShowModal;

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   Evf:= TEvf.ECreate;
   Evf.elso := nil;
   Megjelenites.Enabled := false;
   Kiertekeles.Enabled := false;
end;

procedure TForm1.KilepesClick(Sender: TObject);
begin
   Evf.EFree;
   Application.Terminate;
end;

procedure TForm1.BetoltesClick(Sender: TObject);
var
    d : TDiak;
    Inpf : Textfile;
    i, j : integer;
begin
   if Assigned(Evf.elso) then
   begin
     Evf.EFree;
     Evf := TEvf.ECreate;
     Evf.elso := nil;
   end;
   OpenDialog1.FileName := '*.dat';
   if OpenDialog1.Execute then
    begin
      Fnev := OpenDialog1.FileName;
      Form1.Caption := 'Adat bettltse: ' +
         ExtractFileName(OpenDialog1.FileName);
      AssignFile(Inpf,FNev);
      Reset(Inpf);
      if Assigned(Evf.elso) then
       begin
        Evf.EFree;
        Evf := TEvf.ECreate;
        Evf.elso := nil;
       end;
        While not Eof(Inpf) do
         begin
           d := TDiak.DCreate;
           Readln(Inpf,d.nev,d.tankor,d.kreditpont);
           d.elozo := nil;
           d.kovetkezo := nil;
           j:= 0;
           for i:=1 to length(d.nev) do
             if d.nev[i] = ' ' then j:=j+1
             else break;
           Delete(d.nev,1,j);
           Form3.ListBox1.ITems.Add(d.nev);
           Form2.ListBox1.ITems.Add(d.nev);
           if Evf.elso = nil
             then Evf.elso := d
             else
              begin
                Evf.utolso.kovetkezo := d;
                d.elozo := Evf.utolso;
              end;
              Evf.utolso := d;
         end;
         CloseFile(Inpf);
         Form3.Etankor.Text := IntToStr(Evf.elso.tankor);
         Form3.Ekredit.Text := IntToStr(Evf.elso.kreditpont);
         Form2.Etankor.Text := IntToStr(Evf.elso.tankor);
         Form2.Ekredit.Text := IntToStr(Evf.elso.kreditpont);
    end;
    Megjelenites.Enabled := true;
    Kiertekeles.Enabled := true;
end;

procedure TForm1.MegjelenitesClick(Sender: TObject);
begin
   Form2.ListBox1.Clear;
   Form2.Etankor.Clear;
   Form2.Ekredit.Clear;
   Form2.ShowModal;
end;

procedure TForm1.KiertekelesClick(Sender: TObject);
begin
   Form4.ListBox1.Clear;
   Form4.nev.Clear;
   Form4.tankor.Clear;
   Form4.kreditpont.Clear;
   Form4.ShowModal;
end;

end.
